# from scipy.stats import norm
import math
import time
import pandas as pd
import sys

# Wind API
from WindPy import *
from datetime import datetime
def get_wind_data(startDate):
	# 启动Wind
	w.start()
	
	# 获取当前时间 yyyy-MM-dd 格式
	endDate=datetime.now().strftime('%Y-%m-%d')
	ddln=["ON","7D","1M","3M","6M","9M","1Y","2Y","3Y","4Y","5Y","7Y","10Y"]
	ddln_y=["0Y","0.08Y","0.25Y","0.5Y","0.75Y","1Y","2Y","3Y","4Y","5Y","6Y","7Y","8Y","9Y","10Y"]
	ddln_m=["0.08Y","0.25Y","0.5Y","0.75Y","1Y","2Y","3Y","4Y","5Y","6Y","7Y","8Y","9Y","10Y"]
	result=[]
	
	# FR007利率互换收盘曲线
	IRS001_RES=w.edb("M1001845,M1001846,M1004122,M1004123,M1004124,M1004125,M1004126,M1004127,M1004128,M1004129,M1004130,M1004131,M1004132",
	startDate, endDate,"ShowBlank=0")
	for j in range(len(IRS001_RES.Times)):
		for i in range(len(IRS001_RES.Codes)):
			one=[]
			one.append("IRS001")
			one.append("FR007利率互换收盘曲线")
			one.append(ddln[i])
			if len(IRS001_RES.Data) <2:
				if IRS001_RES.Data[0][i]:
					one.append(IRS001_RES.Data[0][i])
				else :
					one.append("")
			else :
				if IRS001_RES.Data[i][j]:
					one.append(IRS001_RES.Data[i][j])
				else :
					one.append("")
			one.append(IRS001_RES.Times[j].strftime('%Y-%m-%d'))
			one.append(IRS001_RES.Codes[i])
			result.append(one)

	# FR007利率互换定盘曲线（买价）
	IRS002_RES=w.edb("M1001845,M1001846,M1004010,M1004011,M1004012,M1004013,M1004014,M1004015,M1004016,M1004017,M1004018,M1004019,M1004020 ",
	startDate, endDate,"ShowBlank=0")
	for j in range(len(IRS002_RES.Times)):
		for i in range(len(IRS002_RES.Codes)):
			one=[]
			one.append("IRS002")
			one.append("FR007利率互换定盘曲线（买价）")
			one.append(ddln[i])

			if len(IRS002_RES.Data) <2:
				if IRS002_RES.Data[0][i]:
					one.append(IRS002_RES.Data[0][i])
				else :
					one.append("")
			else :
				if IRS002_RES.Data[i][j]:
					one.append(IRS002_RES.Data[i][j])
				else :
					one.append("")

			one.append(IRS002_RES.Times[j].strftime('%Y-%m-%d'))
			one.append(IRS002_RES.Codes[i])
			result.append(one)

	# FR007利率互换定盘曲线（卖价）
	IRS003_RES=w.edb("M1001845,M1001846, M1004021,M1004022,M1004023,M1004024,M1004025,M1004026,M1004027,M1004028,M1004029,M1004030,M1004031 ",
	startDate, endDate,"ShowBlank=0")
	for j in range(len(IRS003_RES.Times)):
		for i in range(len(IRS003_RES.Codes)):
			one=[]
			one.append("IRS003")
			one.append("FR007利率互换定盘曲线（卖价）")
			one.append(ddln[i])
			if len(IRS003_RES.Data) <2:
				if IRS003_RES.Data[0][i]:
					one.append(IRS003_RES.Data[0][i])
				else :
					one.append("")
			else :
				if IRS003_RES.Data[i][j]:
					one.append(IRS003_RES.Data[i][j])
				else :
					one.append("")
			one.append(IRS003_RES.Times[j].strftime('%Y-%m-%d'))
			one.append(IRS003_RES.Codes[i])
			result.append(one)

	# FR007利率互换定盘曲线（均值）
	IRS004_RES=w.edb("M1001845,M1001846, M1004032,M1004033,M1004034,M1004035,M1004036,M1004037,M1004038,M1004039,M1004040,M1004041,M1004042",
	startDate, endDate,"ShowBlank=0")
	for j in range(len(IRS004_RES.Times)):
		for i in range(len(IRS004_RES.Codes)):
			one=[]
			one.append("IRS004")
			one.append("FR007利率互换定盘曲线（均值）")
			one.append(ddln[i])

			if len(IRS004_RES.Data) <2:
				if IRS004_RES.Data[0][i]:
					one.append(IRS004_RES.Data[0][i])
				else :
					one.append("")
			else :
				if IRS004_RES.Data[i][j]:
					one.append(IRS004_RES.Data[i][j])
				else :
					one.append("")

			one.append(IRS004_RES.Times[j].strftime('%Y-%m-%d'))
			one.append(IRS004_RES.Codes[i])
			result.append(one)

	# 国开(SHCH)
	YTM001_RES=w.edb("M1011067,M1011068,M1011069,M1011070,M1011071,M1011072,M1011073,M1011074,M1011075,M1011076,M1011077,M1011078,M1011079,M1011080,M1011081",
	startDate, endDate,"ShowBlank=0")
	for j in range(len(YTM001_RES.Times)):
		for i in range(len(YTM001_RES.Codes)):
			one=[]
			one.append("YTM001")
			one.append("国开债即期收益率曲线（SHCH）")
			one.append(ddln_y[i])

			if len(YTM001_RES.Data) <2:
				if YTM001_RES.Data[0][i]:
					one.append(YTM001_RES.Data[0][i])
				else :
					one.append("")
			else :
				if YTM001_RES.Data[i][j]:
					one.append(YTM001_RES.Data[i][j])
				else :
					one.append("")


			one.append(YTM001_RES.Times[j].strftime('%Y-%m-%d'))
			one.append(YTM001_RES.Codes[i])
			result.append(one)

	# 农发(SHCH)
	YTM002_RES=w.edb("M1011167,M1011168,M1011169,M1011170,M1011171,M1011172,M1011173,M1011174,M1011175,M1011176,M1011177,M1011178,M1011179,M1011180,M1011181",
	startDate, endDate,"ShowBlank=0")
	for j in range(len(YTM002_RES.Times)):
		for i in range(len(YTM002_RES.Codes)):
			one=[]
			one.append("YTM002")
			one.append("农发债即期收益率曲线（SHCH）")
			one.append(ddln_y[i])

			if len(YTM002_RES.Data) <2:
				if YTM002_RES.Data[0][i]:
					one.append(YTM002_RES.Data[0][i])
				else :
					one.append("")
			else :
				if YTM002_RES.Data[i][j]:
						one.append(YTM002_RES.Data[i][j])
				else :
					one.append("")
			one.append(YTM002_RES.Times[j].strftime('%Y-%m-%d'))
			one.append(YTM002_RES.Codes[i])
			result.append(one)

	# 国开（中债）
	YTM003_RES=w.edb("M1004276,M1004706,M1004278,M1004279,M1004280,M1004281,M1004282,M1004283,M1004284,M1004285,M1004286,M1004287,M1004288,M1004707,M1004289",
	startDate, endDate,"ShowBlank=0")
	for j in range(len(YTM003_RES.Times)):
		for i in range(len(YTM003_RES.Codes)):
			one=[]
			one.append("YTM003")
			one.append("国开债即期收益率曲线（中债）")
			one.append(ddln_y[i])

			if len(YTM003_RES.Data) <2:
				if YTM003_RES.Data[0][i]:
					one.append(YTM003_RES.Data[0][i])
				else :
					one.append("")
			else :
				if YTM003_RES.Data[i][j]:
					one.append(YTM003_RES.Data[i][j])
				else :
					one.append("")

			one.append(YTM003_RES.Times[j].strftime('%Y-%m-%d'))
			one.append(YTM003_RES.Codes[i])
			result.append(one)

	# 农发（中债）
	YTM004_RES=w.edb("M1007678,M1007679,M1007680,M1007681,M1007682,M1007683,M1007684,M1007685,M1007686,M1007687,M1007688,M1007689,M1007690,M1007691,M1007692",
	startDate, endDate,"ShowBlank=0")
	for j in range(len(YTM004_RES.Times)):
		for i in range(len(YTM004_RES.Codes)):
			one=[]
			one.append("YTM004")
			one.append("农发债即期收益率曲线（中债）")
			one.append(ddln_y[i])
			
			if len(YTM004_RES.Data) <2:
				if YTM004_RES.Data[0][i]:
					one.append(YTM004_RES.Data[0][i])
				else :
					one.append("")
			else :
				if YTM004_RES.Data[i][j]:
					one.append(YTM004_RES.Data[i][j])
				else :
					one.append("")			
			one.append(YTM004_RES.Times[j].strftime('%Y-%m-%d'))
			one.append(YTM004_RES.Codes[i])
			result.append(one)		

	#国债即期（SHCH）
	YTM005_RES=w.edb("M1008698,M1008699,M1008700,M1008701,M1008702,M1008703,M1008704,M1008705,M1008706,M1008707,M1008708,M1008709,M1008710,M1008711",
	startDate, endDate,"ShowBlank=0")
	for j in range(len(YTM005_RES.Times)):
		for i in range(len(YTM005_RES.Codes)):
			one=[]
			one.append("YTM005")
			one.append("国债即期收益率曲线（SHCH）")
			one.append(ddln_m[i])

			if len(YTM005_RES.Data) <2:
				if YTM005_RES.Data[0][i]:
					one.append(YTM005_RES.Data[0][i])
				else :
					one.append("")
			else :
				if YTM005_RES.Data[i][j]:
					one.append(YTM005_RES.Data[i][j])
				else :
					one.append("")
			one.append(YTM005_RES.Times[j].strftime('%Y-%m-%d'))
			one.append(YTM005_RES.Codes[i])
			result.append(one)
	# 国债即期（中债）
	YTM006_RES=w.edb("M1004179,M1004696,M1001099,M1001100,M1001101,M1001102,M1001103,M1001104,M1001105,M1001106,M1001107,M1001108,M1001109,M1004697,M1001110",
	startDate, endDate,"ShowBlank=0")
	for j in range(len(YTM006_RES.Times)):
		for i in range(len(YTM006_RES.Codes)):
			one=[]
			one.append("YTM006")
			one.append("国债即期收益率曲线（中债）")
			one.append(ddln_y[i])

			if len(YTM006_RES.Data) <2:
				if YTM006_RES.Data[0][i]:
					one.append(YTM006_RES.Data[0][i])
				else :
					one.append("")
			else :
				if YTM006_RES.Data[i][j]:
					one.append(YTM006_RES.Data[i][j])
				else :
					one.append("")
			one.append(YTM006_RES.Times[j].strftime('%Y-%m-%d'))
			one.append(YTM006_RES.Codes[i])
			result.append(one)

	return result
	

if __name__ == '__main__':
	result=get_wind_data(sys.argv[1])
	print(result)


