# from scipy.stats import norm

# Wind API
import sys

from WindPy import *
from datetime import datetime


def get_wind_data():
    # 启动Wind
    w.start()

    # 获取当前时间
    today = datetime.now()

    res = []
    code = []
    wind = []
    # 交易日
    try:
        if len(sys.argv) > 1:
            year = str(sys.argv[1])
            trade_calendar = w.tdays(year + "-01-01", year + "-12-31", "TradingCalendar=NIB")
        else:
            year = today.year + 5
            trade_calendar = w.tdays("2020-01-01", str(year) + "-12-31", "TradingCalendar=NIB")
        # 返回交易日
        if trade_calendar.ErrorCode == 0:
            code.append("sucess")
            res.append(code)
            if len(trade_calendar.Data):
                for i in trade_calendar.Data[0]:
                    wind.append(i.strftime('%Y-%m-%d'))
                res.append(wind)
            else:
                wind.append("")
                res.append(wind)
        else:
            code.append("error")
            res.append(code)
        print(res)
    except Exception as e:
        code.append("error")
        res.append(code)


if __name__ == '__main__':
    get_wind_data()
