# from scipy.stats import norm
import math
import time
import pandas as pd

# Wind API
from WindPy import *
from datetime import datetime
def get_wind_data():
	# 启动Wind
	w.start()

	# 获取当前时间 yyyy-MM-dd 格式
	now=datetime.now().strftime('%Y-%m-%d')
	# print(now)

	# 获取现金交割和实物交割的code数组
	# 现金交割
	code1=w.wset("sectorconstituent","date="+now+";sectorid=1000040838000000").Data[1]
	code2=w.wset("sectorconstituent","date="+now+";sectorid=1000032699000000").Data[1]
	# 实物交割
	code3=w.wset("sectorconstituent","date="+now+";sectorid=1000043555000000").Data[1]
	code4=w.wset("sectorconstituent","date="+now+";sectorid=1000043560000000").Data[1]
	code5=w.wset("sectorconstituent","date="+now+";sectorid=1000043561000000").Data[1]
	#codes =code1+code2+code3+code4+code5
	codes=list(set(code1+code2+code3+code4+code5))
	# print(codes)

	# 从Wind取数
	obj =w.wss(codes, "sec_name,trade_code,dlmonth,ftdate,lasttrade_date,lastdelivery_date").Data
    # 合约上市日期转字符串
	ftdatestrs=[]
	for i in obj[3]:
		ftdatestrs.append(i.strftime('%Y-%m-%d'))


	# 最后交易日转字符串
	lasttrade_datestrs=[]
	for i in obj[4]:
		lasttrade_datestrs.append(i.strftime('%Y-%m-%d'))

	# 最后交易日转字符串
	lastdelivery_datestrs=[]
	for i in obj[5]:
		lastdelivery_datestrs.append(i.strftime('%Y-%m-%d'))

	obj.append(ftdatestrs)
	obj.append(lasttrade_datestrs)
	obj.append(lastdelivery_datestrs)

	# 将需要的字段返回
	res= []
	res.append(obj[0]) # 合约名称
	res.append(obj[1]) # 合约代码+合约品种
	res.append(obj[2]) # 交割月份
	res.append(obj[6]) # 合约上市日期
	res.append(obj[7]) # 最后交易日
	res.append(obj[8]) # 到期交割日
	return res

if __name__ == '__main__':
    result=get_wind_data()
    print(result)


