# Wind API
from WindPy import *


def get_wind_data():
    # 启动Wind
    w.start()
    bondlist = []
    for index in range(len(sys.argv)):
        if index != 0:
            bondlist.append(sys.argv[index])
    # 根据债券代码从Wind获取信息
    bond = w.wsq(bondlist, "rt_remain_maturity,rt_pre_close,rt_last_cp,rt_last_dp,rt_last_ytm,rt_best_bid_ytm,"
                           "rt_best_ask_ytm,rt_date")

    # 将需要的字段返回
    res = [list(map(is_none, bond.Codes)),list(map(is_none, bond.Data[0])), list(map(is_none, bond.Data[1])), list(map(is_none, bond.Data[2])),
           list(map(is_none, bond.Data[3])), list(map(is_none, bond.Data[4])), list(map(is_none, bond.Data[5])),
           list(map(is_none, bond.Data[6])), list(map(is_none, bond.Data[7]))]
    print(res)


def is_none(data):
    if data is None:
        return ''
    else:
        return data


if __name__ == '__main__':
    get_wind_data()
