import math
import sys

import pandas as pd
import re
from datetime import datetime

# Wind API
from WindPy import *


def get_wind_data():
    # 启动Wind
    w.start()

    # 获取当前日期 yyyyMMdd
    tradeDateNow = datetime.now().strftime('%Y%m%d')

    bondlist = []
    for index in range(len(sys.argv)):
        if index != 0:
            bondlist.append(sys.argv[index])
    # 根据债券代码从Wind获取债券信息
    bond = w.wss(bondlist,
                 "windcode,sec_name,term,ptmyear,carrydate,maturitydate,nxcupn,nxcupn2,couponrate,interestfrequency,actualbenchmark,interesttype,coupon,redemption_beginning,issue_issueprice",
                 "tradeDate=%s" % (tradeDateNow)).Data

    # 将需要的字段返回
    res = []
    res.append(list(map(is_none, bond[0])))  # 债券代码
    res.append(list(map(is_none, bond[1])))  # 债券简称
    res.append(list(map(is_none, bond[2])))  # 发行期限
    res.append(list(map(is_none, bond[3])))  # 剩余期限
    res.append(list(map(date_format, bond[4])))  # 起息日
    res.append(list(map(date_format, bond[5])))  # 到期日
    res.append(list(map(date_format, bond[6])))  # 下一付息日
    res.append(list(map(is_none, bond[7])))  # 距下一付息日
    res.append(list(map(is_none, bond[8])))  # 票面利率
    res.append(list(map(is_none, bond[9])))  # 年付息次数
    res.append(list(map(is_none, bond[10])))  # 计息基准
    res.append(list(map(is_none, bond[11])))  # 利率类型
    res.append(list(map(is_none, bond[12])))  # 票息品种
    res.append(list(map(date_format, bond[13])))  # 兑付日
    res.append(list(map(is_none, bond[14])))  # 发行价格
    # 债券对应的所有付息日
    cashflows = []
    for code in bond[0]:
        if code is None:
            cashflows.append([])
        else:
            lis = w.wset("cashflow", "windcode=" + code).Data[0]
            cashflows.append(lis)
    res.append(cashflows)  # 所有付息日
    print(res)


def date_format(data):
    return data.strftime('%Y-%m-%d')


def is_none(data):
    if data is None:
        return ''
    else:
        return data


if __name__ == '__main__':
    get_wind_data()
