# Wind API
import math
from WindPy import *


def get_wind_data():
    # 启动Wind
    w.start()
    endDate = str(sys.argv[1])
    d2 = w.tdaysoffset(-1, endDate, "TradingCalendar=NIB")
    d3 = d2.Times[0]
    arCdList = str(sys.argv[2])
    # 根据合约代码、合约上市日期、债券估值生效日期从Wind获取信息
    price = w.wsd(arCdList, "settle", d3, endDate, "TradingCalendar=NIB;ShowBlank=-1")
    # 将需要的字段返回
    res = []
    for j in range(len(price.Data)):
        res.append(list(map(is_none, price.Data[j])))
    print(res)

def is_none(data):
    if data is None:
        return '-2'
    else:
        return data


if __name__ == '__main__':
    get_wind_data()
