# Wind API
import math
from WindPy import *
import re
from datetime import datetime


def get_wind_data():
    # 启动Wind
    w.start()
    beginDate = str(sys.argv[1])
    endDate = str(sys.argv[2])
    arCdList = str(sys.argv[3])
    # 根据合约代码、合约上市日期、债券估值生效日期从Wind获取信息
    price = w.wsd(arCdList, "settle", beginDate, endDate, "TradingCalendar=NIB;ShowBlank=-1")
    # 将需要的字段返回
    res = []
    for j in range(len(price.Data)):
        res.append(list(map(is_none, price.Data[j])))

    res2 = []
    for j in range(len(price.Times)):
        res2.append(date_format(price.Times[j]))

    res.append(res2)
    print(res)
    
def is_none(data):
    if data is None:
        return '-2'
    else:
        return data

def date_format(data):
    return data.strftime('%Y-%m-%d')

if __name__ == '__main__':
    get_wind_data()
