# Wind API
from WindPy import *


def get_wind_data():
    # 启动Wind
    w.start()

    # 获取当前时间 yyyy-MM-dd
    datenow = datetime.now().strftime('%Y-%m-%d')
    # 获取现金交割和实物交割的合约代码list
    # 现金交割
    code1 = w.wset("sectorconstituent", "date=%s;sectorid=1000032699000000" % (datenow)).Data[1]
    code2 = w.wset("sectorconstituent", "date=%s;sectorid=1000040838000000" % (datenow)).Data[1]
    # 实物交割
    code3 = w.wset("sectorconstituent", "date=%s;sectorid=1000043555000000" % (datenow)).Data[1]
    code4 = w.wset("sectorconstituent", "date=%s;sectorid=1000043560000000" % (datenow)).Data[1]
    code5 = w.wset("sectorconstituent", "date=%s;sectorid=1000043561000000" % (datenow)).Data[1]
    #codes = code1 + code2 + code3 + code4 + code5
    codes=list(set(code1+code2+code3+code4+code5))
    # 合约代码
    ctacCode = []
    # 债券代码
    bondCode = []
    # 转换因子
    cf = []
    for contractCode in codes:
        bond = w.wset("conversionfactor", "windcode=" + contractCode)
        if bond.ErrorCode != 0:
           print(bond)
           return
        else:
          bond=bond.Data
          if bond != []: 
             ctacCode.append(contractCode)
             bondCode.append(bond[0])
             cf.append(bond[1])
    # 将需要的字段返回
    res = [ctacCode, bondCode, cf]
    return res


if __name__ == '__main__':
    result = get_wind_data()
    print(result)
