# Wind API
from WindPy import *


def get_wind_data():
    # 启动Wind
    w.start()
    ctaclist = []
    for index in range(len(sys.argv)):
        if index != 0:
            ctaclist.append(sys.argv[index])
    # 根据合约代码从Wind获取合约信息
    ctac = w.wsq(ctaclist,"rt_pre_settle,rt_latest,rt_chg,rt_bsize1,rt_bid1,rt_ask1,rt_asize1,rt_time")

    # 将需要的字段返回
    res = []
    res.append(list(map(is_none, ctac.Codes)))    # 合约代码
    res.append(list(map(is_none, ctac.Data[0])))  # 前结算价
    res.append(list(map(is_none, ctac.Data[1])))  # 现价
    res.append(list(map(is_none, ctac.Data[2])))  # 涨跌
    res.append(list(map(is_none, ctac.Data[3])))  # 买1量
    res.append(list(map(is_none, ctac.Data[4])))  # 买1价
    res.append(list(map(is_none, ctac.Data[5])))  # 卖1价
    res.append(list(map(is_none, ctac.Data[6])))  # 卖1量
    res.append(list(map(is_none, ctac.Data[7])))  # 时间

    print(res)


def date_format(data):
    return data.strftime('%Y-%m-%d')


def is_none(data):
    if data is None:
        return ''
    else:
        return data


if __name__ == '__main__':
    get_wind_data()