# Wind API
import math
from WindPy import *


def get_wind_data():
    # 启动Wind
    w.start()
    paramlist = []
    for index in range(len(sys.argv)):
        if index != 0:
            paramlist.append(sys.argv[index])
    # 根据合约代码、合约上市日期、债券估值生效日期从Wind获取信息
    price = w.wsd(paramlist[0], "settle", paramlist[1], paramlist[2], "TradingCalendar=NIB")
    # 将需要的字段返回
    res = []
    for j in range(len(price.Times)):
        one = []
        if math.isnan(price.Data[0][j]):
            continue
        else:
            one.append(price.Times[j].strftime('%Y-%m-%d'))
            one.append(price.Data[0][j])
            res.append(one)
    print(res)


if __name__ == '__main__':
    get_wind_data()
