# Wind API
from WindPy import *


def get_wind_data():
    # 启动Wind
    w.start()

    ctacCodelist = []
    for index in range(len(sys.argv)):
        if index != 0:
            ctacCodelist.append(sys.argv[index])
    # 根据合约代码从Wind获取合约现价
    price = w.wsq(ctacCodelist, "rt_latest,rt_ask1,rt_bid1").Data

    # 将需要的字段返回
    res = []
    res.append(list(map(is_none, price[0])))  # 最新价
    res.append(list(map(is_none, price[1])))  # 合约报价-卖价
    res.append(list(map(is_none, price[2])))  # 合约报价-买价
    print(res)


def is_none(data):
    if data is None:
        return ''
    else:
        return data


if __name__ == '__main__':
    get_wind_data()
