# Wind API
from WindPy import *
from datetime import datetime


def get_wind_data(startDate, endDate):
    # 启动Wind
    w.start()
    ddln_y = ["0Y", "0.08Y", "0.25Y", "0.5Y", "0.75Y", "1Y", "2Y", "3Y", "4Y", "5Y", "6Y", "7Y", "8Y", "9Y", "10Y"]
    result = []

    # 国开(SHCH)
    YTM001_RES = w.edb(
        "M1011067,M1011068,M1011069,M1011070,M1011071,M1011072,M1011073,M1011074,M1011075,M1011076,M1011077,M1011078,M1011079,M1011080,M1011081",
        startDate, endDate, "ShowBlank=0")
    for j in range(len(YTM001_RES.Times)):
        for i in range(len(YTM001_RES.Codes)):
            one = []
            one.append("YTM001")
            one.append("国开债即期收益率曲线（SHCH）")
            one.append(ddln_y[i])

            if len(YTM001_RES.Data) < 2:
                if YTM001_RES.Data[0][i]:
                    one.append(YTM001_RES.Data[0][i])
                else:
                    one.append("")
            else:
                if YTM001_RES.Data[i][j]:
                    one.append(YTM001_RES.Data[i][j])
                else:
                    one.append("")
            one.append(YTM001_RES.Times[j].strftime('%Y-%m-%d'))
            one.append(YTM001_RES.Codes[i])
            result.append(one)

    # 农发(SHCH)
    YTM002_RES = w.edb(
        "M1011167,M1011168,M1011169,M1011170,M1011171,M1011172,M1011173,M1011174,M1011175,M1011176,M1011177,M1011178,M1011179,M1011180,M1011181",
        startDate, endDate, "ShowBlank=0")
    for j in range(len(YTM002_RES.Times)):
        for i in range(len(YTM002_RES.Codes)):
            one = []
            one.append("YTM002")
            one.append("农发债即期收益率曲线（SHCH）")
            one.append(ddln_y[i])

            if len(YTM002_RES.Data) < 2:
                if YTM002_RES.Data[0][i]:
                    one.append(YTM002_RES.Data[0][i])
                else:
                    one.append("")
            else:
                if YTM002_RES.Data[i][j]:
                    one.append(YTM002_RES.Data[i][j])
                else:
                    one.append("")
            one.append(YTM002_RES.Times[j].strftime('%Y-%m-%d'))
            one.append(YTM002_RES.Codes[i])
            result.append(one)

    # 国开（中债）
    YTM003_RES = w.edb(
        "M1004276,M1004706,M1004278,M1004279,M1004280,M1004281,M1004282,M1004283,M1004284,M1004285,M1004286,M1004287,M1004288,M1004707,M1004289",
        startDate, endDate, "ShowBlank=0")
    for j in range(len(YTM003_RES.Times)):
        for i in range(len(YTM003_RES.Codes)):
            one = []
            one.append("YTM003")
            one.append("国开债即期收益率曲线（中债）")
            one.append(ddln_y[i])

            if len(YTM003_RES.Data) < 2:
                if YTM003_RES.Data[0][i]:
                    one.append(YTM003_RES.Data[0][i])
                else:
                    one.append("")
            else:
                if YTM003_RES.Data[i][j]:
                    one.append(YTM003_RES.Data[i][j])
                else:
                    one.append("")
            one.append(YTM003_RES.Times[j].strftime('%Y-%m-%d'))
            one.append(YTM003_RES.Codes[i])
            result.append(one)

    # 农发（中债）
    YTM004_RES = w.edb(
        "M1007678,M1007679,M1007680,M1007681,M1007682,M1007683,M1007684,M1007685,M1007686,M1007687,M1007688,M1007689,M1007690,M1007691,M1007692",
        startDate, endDate, "ShowBlank=0")
    for j in range(len(YTM004_RES.Times)):
        for i in range(len(YTM004_RES.Codes)):
            one = []
            one.append("YTM004")
            one.append("农发债即期收益率曲线（中债）")
            one.append(ddln_y[i])

            if len(YTM004_RES.Data) < 2:
                if YTM004_RES.Data[0][i]:
                    one.append(YTM004_RES.Data[0][i])
                else:
                    one.append("")
            else:
                if YTM004_RES.Data[i][j]:
                    one.append(YTM004_RES.Data[i][j])
                else:
                    one.append("")
            one.append(YTM004_RES.Times[j].strftime('%Y-%m-%d'))
            one.append(YTM004_RES.Codes[i])
            result.append(one)

    return result


if __name__ == '__main__':
    result = get_wind_data(sys.argv[1], sys.argv[2])
    print(result)
