/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import java.io.IOException;
import jdk.internal.instrumentation.InstrumentationMethod;
import jdk.internal.instrumentation.InstrumentationTarget;
import jdk.jfr.events.FileReadEvent;
import oracle.jrockit.jfr.VMJFR;

@InstrumentationTarget(value="java.io.FileInputStream")
final class FileInputStreamInstrumentor {
    private String path;

    private FileInputStreamInstrumentor() {
    }

    @InstrumentationMethod
    public int read() throws IOException {
        long l;
        if (!VMJFR.fileReadToken.isEnabled()) {
            return this.read();
        }
        FileReadEvent fileReadEvent = new FileReadEvent(VMJFR.fileReadToken);
        int n = 0;
        try {
            fileReadEvent.begin();
            n = this.read();
            l = n <= 0 ? (long)n : 1L;
        }
        catch (Throwable throwable) {
            fileReadEvent.bytesRead = n <= 0 ? (long)n : 1L;
            fileReadEvent.path = this.path;
            fileReadEvent.commit();
            throw throwable;
        }
        fileReadEvent.bytesRead = l;
        fileReadEvent.path = this.path;
        fileReadEvent.commit();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public int read(byte[] byArray) throws IOException {
        if (!VMJFR.fileReadToken.isEnabled()) {
            return this.read(byArray);
        }
        FileReadEvent fileReadEvent = new FileReadEvent(VMJFR.fileReadToken);
        int n = -1;
        try {
            fileReadEvent.begin();
            n = this.read(byArray);
        }
        finally {
            fileReadEvent.bytesRead = n;
            fileReadEvent.path = this.path;
            fileReadEvent.commit();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (!VMJFR.fileReadToken.isEnabled()) {
            return this.read(byArray, n, n2);
        }
        FileReadEvent fileReadEvent = new FileReadEvent(VMJFR.fileReadToken);
        int n3 = -1;
        try {
            fileReadEvent.begin();
            n3 = this.read(byArray, n, n2);
        }
        finally {
            fileReadEvent.bytesRead = n3;
            fileReadEvent.path = this.path;
            fileReadEvent.commit();
        }
        return n3;
    }
}

